*************************************************************************************************************************************************
******************************INSTITUTO NACIONAL DE ESTADSTICA Y CENSOS****************************************************
***********************************SINTAXIS CUADROS VEHCULOS*********************************************************************
*************************************************************************************************************************************************

**TEMA: TABULADOS VEHCULOS MATRICULADOS 2016.
**DIRECCIN DE ESTADSTICAS ECONMICAS.
**UNIDAD DE GESTIN DE ESTADSTICAS ESTRUCTURALES.
**FECHA: 18/09/2017.

**************CUADRO VM1.

* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=PROVINCIA USO DISPLAY=LABEL
  /TABLE PROVINCIA [COUNT F40.0] BY USO
  /CATEGORIES VARIABLES=PROVINCIA USO ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES 
    POSITION=before
  /TITLES
           TITLE='NMERO DE VEHCULOS MOTORIZADOS MATRICULADOS POR USO, SEGN PROVINCIAS'
           CAPTION='ANUARIO DE TRANSPORTE 2016'.

**************CUADRO VM2

* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=CLASE USO DISPLAY=LABEL
  /TABLE CLASE BY USO [C][COUNT F40.0]
  /CATEGORIES VARIABLES=CLASE USO ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=before
  /TITLES
	TITLE='NMERO DE VEHCULOS MOTORIZADOS MATRICULADOS POR USO, SEGN CLASE'
          	CAPTION='ANUARIO DE TRANSPORTE 2016'.

**************CUADRO  VM3

* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=MODELO USO DISPLAY=LABEL
  /TABLE MODELO [C] BY USO [C][COUNT F40.0]
  /CATEGORIES VARIABLES=MODELO [1, OTHERNM] EMPTY=exclude TOTAL=YES POSITION=before
  /CATEGORIES VARIABLES=USO ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=before
  /TITLES
	TITLE='NMERO DE VEHCULOS MOTORIZADOS MATRICULADOS POR USO, SEGN MODELO (AO DE FABRICACIN)'
          	CAPTION='ANUARIO DE TRANSPORTE 2016'.

**************CUADRO VM4

* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=PROVINCIA CLASE DISPLAY=LABEL
  /TABLE PROVINCIA [COUNT F40.0] BY CLASE
  /CATEGORIES VARIABLES=PROVINCIA CLASE ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=before
  /TITLES
	TITLE='NMERO DE VEHCULOS MOTORIZADOS MATRICULADOS POR CLASE, SEGN PROVINCIA'
           	CAPTION='ANUARIO DE TRANSPORTE 2016'.

**************CUADRO VM5

* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=CLASE MODELO DISPLAY=LABEL
  /TABLE CLASE BY MODELO [C][COUNT F40.0]
  /CATEGORIES VARIABLES=CLASE ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=before
  /CATEGORIES VARIABLES=MODELO [1, OTHERNM] EMPTY=exclude TOTAL=YES POSITION=before
  /TITLES
	TITLE='NMERO DE VEHCULOS MOTORIZADOS MATRICULADOS POR MODELO (AO DE FABRICACIN), SEGN CLASE'
          	CAPTION='ANUARIO DE TRANSPORTE 2016'.

**************CUADRO VM6

* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=MARCA MODELO DISPLAY=LABEL
  /TABLE MARCA BY MODELO [C][COUNT F40.0]
  /CATEGORIES VARIABLES=MARCA ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=before
  /CATEGORIES VARIABLES=MODELO [1, OTHERNM] EMPTY=exclude TOTAL=YES POSITION=before
  /TITLES
	TITLE='NMERO DE VEHCULOS MOTORIZADOS MATRICULADOS POR MODELO (AO DE FABRICACIN), SEGN MARCA'
          	CAPTION='ANUARIO DE TRANSPORTE 2016'.

**************CUADRO VM7

* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=PROVINCIA MODELO DISPLAY=LABEL
  /TABLE PROVINCIA BY MODELO [C][COUNT F40.0]
  /CATEGORIES VARIABLES=PROVINCIA ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=before
  /CATEGORIES VARIABLES=MODELO [1, OTHERNM] EMPTY=exclude TOTAL=YES POSITION=before
  /TITLES
	TITLE='NMERO DE VEHCULOS MOTORIZADOS MATRICULADOS POR MODELO (AO DE FABRICACIN), SEGN PROVINCIA'
          	CAPTION='ANUARIO DE TRANSPORTE 2016'.

**************CUADRO VM8

* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=MARCA CLASE DISPLAY=LABEL
  /TABLE MARCA [C][COUNT F40.0] BY CLASE
  /CATEGORIES VARIABLES=MARCA CLASE ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=before
  /TITLES
	TITLE='NMERO DE VEHCULOS MOTORIZADOS MATRICULADOS POR CLASE, SEGN MARCA'
          	CAPTION='ANUARIO DE TRANSPORTE 2016'.

**************CUADRO VM9

***FILTRO PARA VEHCULOS CON PASAJEROS**.

USE ALL.
COMPUTE filpasajero=(CLASE= 1  |  CLASE=2  |  CLASE= 6  |  CLASE= 7  |  CLASE= 8  |  CLASE = 12).
VARIABLE LABEL filpasajero 'Filtro de vehculos para capacidad de asientos'.
VALUE LABELS filpasajero 0 'Not Selected' 1 'Selected'.
FORMAT filpasajero (f1.0).
FILTER BY filpasajero.
EXECUTE.


* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=CLASE PASAJEROS ESTRAPASAJE DISPLAY=LABEL
  /TABLE CLASE [C] BY PASAJEROS [S][SUM] + ESTRAPASAJE [C][COUNT F40.0]
  /CATEGORIES VARIABLES=CLASE [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, OTHERNM] EMPTY=EXCLUDE 
    TOTAL=YES POSITION=before
  /CATEGORIES VARIABLES=ESTRAPASAJE [1.00, 2.00, 3.00, 4.00, 5.00, OTHERNM] EMPTY=EXCLUDE TOTAL=YES 
    POSITION=before
   /TITLES
	TITLE='NMERO DE VEHCULOS MOTORIZADOS MATRICULADOS POR CAPACIDAD DE PASAJEROS, SEGN CLASE'
          	CAPTION='ANUARIO DE TRANSPORTE 2016'.

FILTER OFF.


**************CUADRO VM10

***FILTRO PARA VEHCULOS CON TONELADA

USE ALL.
COMPUTE filtonelaje=(CLASE= 3  |  CLASE=4  |  CLASE= 5  |  CLASE= 9  |  CLASE= 10  | CLASE= 11 | CLASE = 12).
VARIABLE LABEL filtonelaje 'Filtro de vehculos para capacidad de tonelaje'.
VALUE LABELS filtonelaje 0 'Not Selected' 1 'Selected'.
FORMAT filtonelaje (f1.0).
FILTER BY filtonelaje.
EXECUTE.


* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=CLASE TONELAJE ESTRATONE DISPLAY=LABEL
  /TABLE CLASE BY TONELAJE [SUM] + ESTRATONE [C][COUNT F40.0]
  /CATEGORIES VARIABLES=CLASE [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, OTHERNM] EMPTY=EXCLUDE 
    TOTAL=YES POSITION=before
  /CATEGORIES VARIABLES=ESTRATONE [1.00, 2.00, 3.00, 4.00, 5.00, OTHERNM] EMPTY=EXCLUDE TOTAL=YES 
    POSITION=before
  /TITLES
	TITLE='NMERO DE VEHCULOS MOTORIZADOS MATRICULADOS POR CAPACIDAD DE CARGA, SEGN CLASE'
          	CAPTION='ANUARIO DE TRANSPORTE 2016'.

FILTER OFF.

**************CUADRO VM11

**** FILTRO PARA VEHCULOS CON PASAJEROS

FILTER BY filpasajero.
EXECUTE.

* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=PROVINCIA ESTRAPASAJE DISPLAY=LABEL
  /TABLE PROVINCIA BY PASAJEROS [SUM] + ESTRAPASAJE [C][COUNT F40.0]
  /CATEGORIES VARIABLES=PROVINCIA ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=before
  /CATEGORIES VARIABLES=ESTRAPASAJE [1.00, 2.00, 3.00, 4.00, 5.00, OTHERNM] EMPTY=exclude TOTAL=YES 
    POSITION=before
   /TITLES
	TITLE='NMERO DE VEHCULOS MOTORIZADOS MATRICULADOS POR CAPACIDAD DE PASAJEROS, SEGN PROVINCIA'
          	CAPTION='ANUARIO DE TRANSPORTE 2016'.

FILTER OFF.


**************CUADRO VM12

***FILTRO PARA VEHCULOS CON TONELADA

FILTER BY filtonelaje.
EXECUTE.

* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=PROVINCIA TONELAJE ESTRATONE DISPLAY=LABEL
  /TABLE PROVINCIA [C] BY TONELAJE  [SUM] + ESTRATONE [C][COUNT F40.0]
  /CATEGORIES VARIABLES=PROVINCIA ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=before
  /CATEGORIES VARIABLES=ESTRATONE [1.00, 2.00, 3.00, 4.00, 5.00, OTHERNM] EMPTY=exclude TOTAL=YES 
    POSITION=before
   /TITLES
	TITLE='NMERO DE VEHCULOS MOTORIZADOS MATRICULADOS POR CAPACIDAD DE CARGA, SEGN PROVINCIA'
          	CAPTION='ANUARIO DE TRANSPORTE 2016'.

FILTER OFF.


**************CUADRO VM13

* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=PROVINCIA COMBUSTIBLE USO DISPLAY=BOTH
  /TABLE PROVINCIA > COMBUSTIBLE [C][COUNT F40.0] BY USO
  /CATEGORIES VARIABLES=PROVINCIA USO ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=before 
  /CATEGORIES VARIABLES=COMBUSTIBLE ORDER=A KEY=VALUE EMPTY=exCLUDE
  /TITLES
	TITLE='NMERO DE VEHCULOS MOTORIZADOS MATRICULADOS POR USO, SEGN PROVINCIA Y TIPO DE COMBUSTIBLE'
          	CAPTION='ANUARIO DE TRANSPORTE 2016'.

**************CUADRO VM14


* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=CLASE COMBUSTIBLE USO DISPLAY=BOTH
  /TABLE CLASE > COMBUSTIBLE [C][COUNT F40.0] BY USO [C]
  /CATEGORIES VARIABLES=CLASE [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, OTHERNM] EMPTY=exclude 
    TOTAL=YES POSITION=before
  /CATEGORIES VARIABLES=COMBUSTIBLE ORDER=A KEY=VALUE EMPTY=exCLUDE
  /CATEGORIES VARIABLES=USO ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=before
  /TITLES
	TITLE='NMERO DE VEHCULOS MOTORIZADOS MATRICULADOS POR USO, SEGN CLASE Y TIPO DE COMBUSTIBLE'
          	CAPTION='ANUARIO DE TRANSPORTE 2016'.

****ELIMINAMOS VARIABLES FILTRO***.

DELETE VARIABLES filtonelaje filpasajero.
EXECUTE.










